<?php
class Penjualanmodel extends CI_Model {
    function __construct()
    {
        parent::__construct();
		$this->tabel = "penjualan";
		$this->tabeldetail = "detilpenjualan";
		$this->tabelbarang = "barang";
		$this->tabelpelanggan = "pelanggan";
    }
	//simpan ke tabel penjualan
	function save($data){
		if($this->db->insert($this->tabel,$data)){
			$msg = "Data berhasil disimpan";$num="0";$stat="success";
		}else{
			$msg = "Data gagal disimpan <br> ".$this->db->_error_message();
			$num = $this->db->_error_number();
			$stat = "danger";
		}
		return array($stat,$msg,$num);
	}
	//simpan tabel detiljual
	function saveDetail($datadetail){
		if($this->db->insert($this->tabeldetail,$datadetail)){
			return true;
		}else{
			return false;
		}
	}
	//kurangi stok
	function kuranginStok($kdbrg,$qty){
		$this->db->where('kdbarang', $kdbrg);
		$this->db->set('stok', "stok-$qty", FALSE);
		$this->db->update($this->tabelbarang);
	}
	//ambil penjualan berdasarkan no penjualan
	function getDataById($nopenjualan){
		$this->db->select('*');
		$this->db->from($this->tabel);
		$this->db->where('nopenjualan', $nopenjualan);
		$query = $this->db->get();
		$row = $query->result_array();
		return $row;
	}
	//ambil data penjualan semuanya
	function getDataPenjualan(){
		$this->db->select($this->tabel.'.nopenjualan, tglpenjualan, nmpelanggan');
		$this->db->from($this->tabel);
		$this->db->join($this->tabelpelanggan, $this->tabelpelanggan.'.kd_plg = '.$this->tabel.'.kd_plg');
		$query = $this->db->get();
		$row = $query->result_array();
		return $row;
	}
	
	function update($data,$id){
		$this->db->where('nopenjualan', $id);
		if($this->db->update($this->tabel, $data)){
			$msg = "Data berhasil disimpan";$num="0";$stat="success";
		}else{
			$msg = "Data gagal disimpan <br> ".$this->db->_error_message();
			$num = $this->db->_error_number();
			$stat = "danger";
		}
		return array($stat,$msg,$num);
	}
	
	function getDetail($idjual){
		$this->db->select('nmbarang,harga,'.$this->tabeldetail.'.*');
		$this->db->from($this->tabeldetail);
		$this->db->join($this->tabelbarang, $this->tabelbarang.'.kdbarang = '.$this->tabeldetail.'.kdbarang');
		$this->db->where('nopenjualan',$idjual);
		$query = $this->db->get();
		//echo $this->db->last_query();
		$row = $query->result_array();
		return $row;
	}
	
	function deleteDetail($id){
		//ambil dulu datanya
		$this->db->select('qty,kdbarang');
		$this->db->from($this->tabeldetail);
		$this->db->where('nopenjualan', $id);
		$query = $this->db->get();
		$row = $query->result_array();
		foreach($row as $index=>$value)
		{
			//print_r($value);
			$kdbarang = $value['kdbarang'];
			$qty = $value['qty'];
			//update stok bertambah dulu
			$this->db->where('kdbarang', $kdbarang);
			$this->db->set('stok', "stok+$qty", FALSE);
			$this->db->update($this->tabelbarang);
		//	echo $this->db->last_query();
		}
		$this->db->where('nopenjualan', $id);
		$this->db->delete($this->tabeldetail); 
		//echo $this->db->last_query();
		//die();
	}
	
	
}
?>
