<?php if ( ! defined('BASEPATH')) exit('No direct script access allowed');

class simpannilai extends CI_Controller {

	public function __construct()
	{
		parent::__construct();

		$this->load->library('grocery_CRUD');
		$this->mylib->cek_adm_login();
		//ambil url controllernya untuk hak akses
		$this->load->Model('penjualan/Levelmenumodel');
		$this->data['urlcontroller'] = $this->uri->segment(2);
		$this->data['hakakses'] = $this->Levelmenumodel->getAkses($this->session->userdata('level'),$this->data['urlcontroller']);
	}

	public function index()
	{
		$crud = new grocery_CRUD();
	
		$crud->set_table('simpannilai');
		$crud->columns('*');
		$crud->set_subject('simpannilai');
		if($this->data['hakakses']['cancreate']!='1') $crud->unset_add();
		if($this->data['hakakses']['candelete']!='1') $crud->unset_delete();
		if($this->data['hakakses']['canupdate']!='1') $crud->unset_edit();
		if($this->data['hakakses']['canread']!='1') {
			$crud->unset_read();
			$crud->unset_print();
			$crud->unset_export();
			//$crud->unset_list();
		}
		$crud->display_as('namamahasiswa','nama mahasiswa')
			 ->display_as('namamatakuliah','Nama simpannilai')
			 ->display_as('uts','uts simpannilai')
			 ->display_as('tugas','Merek')
			 ->display_as('uas','Kategori');
		//ubah jadi textarea, default pake ckeditor
		 $crud->unset_texteditor('uts','full_text');
		$state = $crud->getState();
		
		$crud->callback_column('uts',array($this,'_callback_uts'));

		  
		//kode simpannilai tidak boleh sama saat insert
		if($state == 'add')
		{
			$crud->required_fields('namamahasiswa','namamatakuliah','uts','stok','uas');
			$crud->set_rules('namamahasiswa','Kode simpannilai','is_unique[simpannilai.namamahasiswa]');
		}
		if($state == 'edit')
		{
			$crud->field_type('namamahasiswa','hidden');
		}
		

		//$crud->set_relation('uas','','namakat');
		//$crud->set_relation('tugas','merek','namamerek');
		//ubah jadi file field untuk upload
		$crud->set_field_upload('foto','assets/uploads/files');
		
		$output = $crud->render();
		
		
		$this->load->template_adm('simpannilai_view',(array)$output);
	}
	function _callback_uts($value)
	{
		return wordwrap($value,30,"<br>\n");
	}
	
}

