<?php if ( ! defined('BASEPATH')) exit('No direct script access allowed');

class Penjualan extends CI_Controller {
	public function __construct(){
		parent::__construct();
		$this->load->Model("penjualan/Penjualanmodel");
		$this->load->Model("penjualan/Generalmodel");
		$this->load->Model('penjualan/Barangmodel');
		$this->load->Model('penjualan/Pelangganmodel');
		$this->mylib->cek_adm_login();
		$this->data['js_files'][] = asset_url().'vendors/datepicker/js/bootstrap-datepicker.min.js';
		$this->data['js_files'][] = js_url().'penjualan/penjualan.js';
		$this->data['css_files'][] = asset_url().'vendors/datepicker/css/bootstrap-datepicker.min.css';
		
		//$this->getData('*');

	}
	public function index($renderData=""){	
		$this->jstambahan = "";
		$this->getDataBarang();
		$this->getDataPelanggan();
		$this->getDataPenjualan();
		$this->load->template_adm('Penjualan_view',$this->data);
	}
	
	/* ambil data pelanggan */
	public function getDataPelanggan(){
		if(isset($_POST['id'])) {
			$data['kd_plg'] = $_POST['id'];
			$brg = $this->Pelangganmodel->getDataById($data['kd_plg']);
			echo json_encode($brg[0]);
		}else{
			$data['kd_plg'] = '';
			$this->data['listdataplg'] = $this->Pelangganmodel->getData();
		}
		$this->data['listdataplg'] = $this->Pelangganmodel->getData();
	}
	
	/* ambil no penjualan terakhir, bisa via AJAX atau NOAJAX */
	public function getNoPenjualan($tipe='AJAX'){
		//generate no penjualan dimulai huruf Jxxxxx
		$data = $this->Generalmodel->autonumber('J','penjualan','nopenjualan','5');
		if($tipe=='AJAX'){ echo json_encode($data);}else {return $data['kode'];}
		exit;
	}
	/* ambil semua data barang, jika ada parameter post id, ambil berdasarkan id */
	public function getDataBarang(){
		
		//cek apakah dikirim via ajax dengan memberikan $_POST['id']?
		if(isset($_POST['id'])) {
			$data['kd_barang'] = $_POST['id'];
			//ambil data barang berdasarkan id
			$brg = $this->Barangmodel->getDataById($data['kd_barang']);
			echo json_encode($brg[0]);
		}else{
			$data['kd_barang'] = '';
			$this->data['listdatabarang'] = $this->Barangmodel->getData();
		}
	}
	/* ambil data penjualan */
	public function getDataPenjualan(){
		$this->data['listdatapenjualan'] = $this->Penjualanmodel->getDataPenjualan();
	}
	
	/* proses simpan ke tabel*/ 
	public function save(){
		$data['tglpenjualan'] = $this->input->post("tglpenjualan");
		$data['kd_plg'] = $this->input->post("kd_plg");
		$data['tgllog'] = date('Y-m-d H:i:s');
		$data['userlog'] = $this->session->userdata('username');
		if($this->input->post("tblsimpan")){
			//echo "kesini";
			$this->db->trans_start();
			$data['nopenjualan'] = $this->getNoPenjualan('NO_AJAX');
			//simpan dulu ke tabel penjualan
			$this->data['message'] = $this->Penjualanmodel->save($data);	
			//kalo gak ada error, simpan ke tabel detilpenjualan
			if($this->data['message'][0]=='success'){
				//looping untuk detilpenjualan
				$qtyjual = $this->input->post("qtyjual");
				$hargajual = $this->input->post("hargajual");
				$datadetail['nopenjualan'] = $data['nopenjualan'];
				foreach($this->input->post("kdbrgjual") as $index=>$kdbrg){
					$datadetail['kdbarang'] = $kdbrg;
					$datadetail['qty'] = $qtyjual[$index];
					$datadetail['harsat'] = $hargajual[$index];
					$this->Penjualanmodel->saveDetail($datadetail);
					//kurangin stok
					$this->Penjualanmodel->kuranginStok($kdbrg,$datadetail['qty']);
				}			
			}
			$this->db->trans_complete();
			if ($this->db->trans_status() === FALSE)
			{
				$this->db->trans_rollback();
				$this->data['message'] = array("danger","Transaksi gagal dibuat <br>".$this->db->_error_message());
			}
			else
			{
				$this->db->trans_commit();
				$this->data['message'] = array("success","Transaksi berhasil dibuat.",0);
			}
			$this->index();
			$this->load->template_adm('Penjualan_view',$this->data);


		}elseif($this->input->post("tblubah")){
		//die('ubah');
			$nopenjualan = $this->input->post('nopenjualan');
				$this->db->trans_start();
				$this->data['message'] = $this->Penjualanmodel->update($data,$nopenjualan);
				//echo $this->db->last_query();
				//update detail.. hapus dulu baru insert lagi
				if($this->data['message'][0]=='success'){
					$this->Penjualanmodel->deleteDetail($nopenjualan);
					//echo $this->db->last_query();
					//looping untuk 
					$qtyjual = $this->input->post("qtyjual");
					$hargajual = $this->input->post("hargajual");
					$datadetail['nopenjualan'] = $nopenjualan;
					foreach($this->input->post("kdbrgjual") as $index=>$kdbrg){
						$datadetail['kdbarang'] = $kdbrg;
						$datadetail['qty'] = $qtyjual[$index];
						$datadetail['harsat'] = $hargajual[$index];
						$this->Penjualanmodel->saveDetail($datadetail);
						//kurangin stok
						$this->Penjualanmodel->kuranginStok($kdbrg,$datadetail['qty']);
					}			
				}
				
				$this->db->trans_complete();
				if ($this->db->trans_status() === FALSE)
				{
					$this->db->trans_rollback();
					$this->data['message'] = array("danger","Transaksi gagal disimpan <br>".$this->db->_error_message(),$this->db->_error_number());
				}
				else
				{
					$this->db->trans_commit();
					$this->data['message'] = array("success","Transaksi berhasil disimpan.",0);
				}
			$this->tampil($nopenjualan);
			
		}else{
			redirect($this->uricontroller);
		}
	}
	//tampilkan penjualan untuk diubah
	public function tampil($nopenjualan){
		//cek ada gak nopenjualan
		if(!isset($nopenjualan)||$nopenjualan==''){
			redirect('penjualan/Penjualan');
		}
		//buat di popup
		$this->getDataPenjualan();
		//ambil data penjualan berdasarkan nopenjualan
		$cek = $this->Penjualanmodel->getDataById($nopenjualan);
		
		$cekarr = array_filter($cek);
		//kalo ada datanya, ambil data
		if(!empty($cekarr)){
			$this->data['listdatabarang'] = $this->Barangmodel->getData();
			$this->data['dataPenjualan'] = $cek[0];
			 //ambil data pelanggan
			$this->getDataPelanggan();
			$this->data['dataDetilJual'] = $this->Penjualanmodel->getDetail($nopenjualan);
			$this->load->template_adm('Penjualan_view',$this->data);
		}else{
			redirect('penjualan/Penjualan');
		}
	}
	public function cetak($idpo){
		if(!isset($idpo)||$idpo==''){
			redirect($this->uricontroller);
		}
		$this->hasNav = false;
		$cek = $this->Pomodel->getDataById($idpo);
		$cekarr = array_filter($cek);
		if(!empty($cekarr)){
			$this->getDataBarang('');
			$this->data['dataPo'] = $cek[0];
			$tgl = $cek[0]['tgl_po'];
			$tgl1 = explode(" ",$tgl);
			$this->data['dataPo']['tgl_po'] = $tgl1[0];
			$idsup = $cek[0]['kd_supp'];
			$x = $this->Suppliermodel->getDataById($idsup);
			$this->data['dataSupplier'] = $x[0];
			$this->data['dataDetilpo'] = $this->Pomodel->getDetail($idpo);
			$this->load->view('pages/cetakpo2',$this->data);
		}else{
			redirect($this->uricontroller);
		}
	}
	
	public function getData($field){
		$this->data['listdata'] = $this->Pelangganmodel->getData($field,'belumkirim');
	}
	public function getDataById($renderData="AJAX"){
		$a = $this->Pomodel->getDataById($_POST['id']);
		echo json_encode($a[0]);
	}
	
		
}