<?php if ( ! defined('BASEPATH')) exit('No direct script access allowed');

require 'vendor/autoload.php';
use PhpOffice\PhpSpreadsheet\Spreadsheet;
use PhpOffice\PhpSpreadsheet\Writer\Xlsx;
		
class Lapjual extends CI_Controller {

	public function __construct()
	{
		parent::__construct();
		$this->mylib->cek_adm_login();
		$this->load->library('pdf');
		$this->load->model('penjualan/Lapjualmodel');
		//datepicker
		$this->data['js_files'][] = asset_url().'vendors/datepicker/js/bootstrap-datepicker.min.js';
		$this->data['css_files'][] = asset_url().'vendors/datepicker/css/bootstrap-datepicker.min.css';
		$this->data['js_files'][] = js_url().'penjualan/lapjual.js';
	}

	public function index()
	{
		//pilih tgl awal dan tanggal akhir
		$this->load->template_adm('Lapjual_view',$this->data);
	}
	function cetak()
	{
	
		if($this->input->post('tblcetak'))
		{
			
			$tglawal = $this->input->post('tglawal');
			$tglakhir = $this->input->post('tglakhir');
			$format = $this->input->post('format');
			//cek dulu ada datanya gak? kalo gak ada munculin error_get_last
			$cekdata = $this->Lapjualmodel->cekPenjualan($tglawal,$tglakhir);
			if($cekdata){
				if($format=='pdf')
				{
					$this->laporanpdf($tglawal,$tglakhir);
				}
				elseif($format=='xls')
				{
					$this->laporanxls($tglawal,$tglakhir);
				}
			}
			else
			{
				$this->data['error'] = "Data Penjualan Tidak Ditemukan";
				$this->load->template_adm('Lapjual_view',$this->data);
			}
		}
		else
		{
			redirect('penjualan/Lapjual/index');
		}
	}
	
	function laporanpdf($tglawal,$tglakhir)
	{
		$tglAwalIndo = $this->mylib->tglIndo($tglawal);
		$tglAkhirIndo = $this->mylib->tglIndo($tglakhir);
		//ambil data laporan
		$dtlaporan = $this->Lapjualmodel->getLaporan($tglawal,$tglakhir);
		
		//buat objek berdasarkan class fpdf
		$pdf = new FPDF();
		$pdf->AddPage();
		//font arial tebal ukuran 16
		$pdf->SetFont('Arial','B',16);
		//cetak, lebar 190, tinggi 7, border 0, tidak ada enter setelahnya, rata Center
		$pdf->Cell(190,7,'LAPORAN PENJUALAN',0,0,'C');	
		//enter
		$pdf->Ln();
		$pdf->Cell(190,7,$tglAwalIndo.' - '.$tglAkhirIndo,0,1,'C');	
		$pdf->Ln();
		//buat header table data, tentukan label, panjang kolom dan perataan
		$header = array(
			array("label"=>"No Penjualan", "length"=>30, "align"=>"C"),
			array("label"=>"Tgl Penjualan", "length"=>40, "align"=>"C"),
			array("label"=>"Nama Pelanggan", "length"=>40, "align"=>"C"),
			array("label"=>"Total", "length"=>30, "align"=>"R"),
		);
		$pdf->SetFont('Arial','','10');
		//latar belakang warna hitam
		$pdf->SetFillColor(0,0,0);
		//text warna putih
		$pdf->SetTextColor(255,255,255);
		//warna border/garis tepi kolom
		$pdf->SetDrawColor(128,0,0);
		//print header
		foreach ($header as $kolom) {
			//parameter terakhir, jika true berarti menggunakan warna latar belakang
			$pdf->Cell($kolom['length'], 5, $kolom['label'], 1, '0', 'C', true);
		}
		$pdf->Ln();
		#tampilkan data tabelnya
		$pdf->SetFillColor(224,235,255);
		$pdf->SetTextColor(0);
		$pdf->SetFont('Arial','','9');
		$fill=false;
		$total = 0;
		//looping tampilkan data laporan
		foreach ($dtlaporan as $id=>$detil) {
			$i = 0;
			$subTotal = $detil['orderTotal'];
			$total = $total + $subTotal;
			//jadiin format rupiah indonesia
			$detil['orderTotal'] = $this->mylib->rupiah($detil['orderTotal']);
			//jadiin tgl indonesia
			$detil['tglpenjualan'] = $this->mylib->tglIndo($detil['tglpenjualan']);
			foreach ($detil as $cell) {
				$pdf->Cell($header[$i]['length'], 5, $cell, 1, '0', $header[$i]['align'], $fill);
				$i++;
			}
			$fill = !$fill;
			
			$pdf->Ln();
		}
		//munculin total
		$pdf->SetFont('Arial','B','10');
		$pdf->Cell(110, 5, 'Total', 1, '0', 'C', true);
		$pdf->Cell(30, 5, $this->mylib->rupiah($total), 1, '0', 'R', true);
		//download dengan nama laporan.pdf
		$pdf->Output('D','laporanjual.pdf'); 		
		
	}
	function laporanxls($tglawal,$tglakhir)
	{
		$tglAwalIndo = $this->mylib->tglIndo($tglawal);
		$tglAkhirIndo = $this->mylib->tglIndo($tglakhir);
		//ambil data laporan
		$dtlaporan = $this->Lapjualmodel->getLaporan($tglawal,$tglakhir);
		
		$spreadsheet = new Spreadsheet();
		$spreadsheet->setActiveSheetIndex(0)
					->setCellValue('A1', 'LAPORAN PENJUALAN')
					->setCellValue('A2', $tglAwalIndo.' - '.$tglAkhirIndo);
        $spreadsheet->setActiveSheetIndex(0)
					->setCellValue('A4', 'No Penjualan')
					->setCellValue('B4', 'Tgl Penjualan')
					->setCellValue('C4', 'Nama Pelanggan')
					->setCellValue('D4', 'Total');
        
		//looping data
		$i=5; 
		$total = 0;
		foreach ($dtlaporan as $id=>$dt)
		{
			$subTotal = $dt['orderTotal'];
			$total = $total + $subTotal;
			
			$spreadsheet->setActiveSheetIndex(0)
						->setCellValue('A'.$i, $dt['nopenjualan'])	
						->setCellValue('B'.$i, $this->mylib->tglIndo($dt['tglpenjualan']))	
						->setCellValue('C'.$i, $dt['nmpelanggan'])	
						->setCellValue('D'.$i, $dt['orderTotal']);	
			$i++;
		}
		$spreadsheet->setActiveSheetIndex(0)
					->setCellValue('A'.$i, 'Total')	
					->setCellValue('D'.$i, $total);	
					
		$spreadsheet->getActiveSheet()->setTitle('Laporan Penjualan '.date('d-m-Y'));

		$writer = new Xlsx($spreadsheet);
        $filename = 'laporanpenjualan';
        header('Content-Type: application/vnd.ms-excel');
        header('Content-Disposition: attachment;filename="'. $filename .'.xlsx"'); 
        header('Cache-Control: max-age=0');
        $writer->save('php://output'); // download file 
	}
	
}

