<?php if ( ! defined('BASEPATH')) exit('No direct script access allowed');
//panggil phpspreadsheet
require 'vendor/autoload.php';
use PhpOffice\PhpSpreadsheet\Spreadsheet;
use PhpOffice\PhpSpreadsheet\Writer\Xlsx;
		
class Lapbarang extends CI_Controller {

	public function __construct()
	{
		parent::__construct();
		$this->mylib->cek_adm_login();
		//panggil library pdf
		$this->load->library('pdf');
		$this->load->model('adm/Lapbarangmodel');
	}

	public function index()
	{
		//tampilin kategori, mau pilih semua atau per kategori
		$this->data['kategori'] = $this->Lapbarangmodel->getKategori();
		$this->load->template_adm('Lapbarang_view',$this->data);
	}
	function cetak()
	{
		if($this->input->post('tblcetak'))
		{
			$idkat = $this->input->post('idkat');
			$format = $this->input->post('format');
			if($format=='pdf')
			{
				$this->laporanpdf($idkat);
			}
			elseif($format=='xls')
			{
				$this->laporanxls($idkat);
			}
		}
		else
		{
			redirect('adm/Lapbarang/index');
		}
	}
	
	function laporanpdf($idkat)
	{
		//cari nama kategori
		if($idkat=='') 
		{
			$nmkategori = "SEMUA KATEGORI";
		}else
		{
			$dtkat = $this->Lapbarangmodel->getKategori($idkat);
			$nmkategori = $dtkat[0]['namakat'];
		}
		//ambil data barang
		$dtbarang = $this->Lapbarangmodel->getBarang($idkat);
		
		//buat objek berdasarkan class fpdf
		$pdf = new FPDF();
		$pdf->AddPage();
		//font arial tebal ukuran 16
		$pdf->SetFont('Arial','B',16);
		//cetak, lebar 190, tinggi 7, border 0, tidak ada enter setelahnya, rata Center
		$pdf->Cell(190,7,'LAPORAN DATA BARANG',0,0,'C');	
		//enter
		$pdf->Ln();
		$pdf->Cell(190,7,$nmkategori,0,1,'C');	
		$pdf->Ln();
		//buat header table data, tentukan label, panjang kolom dan perataan
		$header = array(
			array("label"=>"Kode Barang", "length"=>30, "align"=>"C"),
			array("label"=>"Nama Barang", "length"=>60, "align"=>"C"),
			array("label"=>"Stok", "length"=>30, "align"=>"R"),
			array("label"=>"Harga", "length"=>30, "align"=>"R"),
		);
		$pdf->SetFont('Arial','','10');
		//latar belakang warna hitam
		$pdf->SetFillColor(0,0,0);
		//text warna putih
		$pdf->SetTextColor(255,255,255);
		//warna border/garis tepi kolom
		$pdf->SetDrawColor(128,0,0);
		//print header
		foreach ($header as $kolom) {
			//parameter terakhir, jika true berarti menggunakan warna latar belakang
			$pdf->Cell($kolom['length'], 5, $kolom['label'], 1, '0', 'C', true);
		}
		$pdf->Ln();
		#tampilkan data tabelnya
		$pdf->SetFillColor(224,235,255);
		$pdf->SetTextColor(0);
		$pdf->SetFont('Arial','','9');
		$fill=false;
		$total = 0;
		//looping tampilkan nama barang
		foreach ($dtbarang as $id=>$detil) {
			$i = 0;
			foreach ($detil as $cell) {
				$pdf->Cell($header[$i]['length'], 5, $cell, 1, '0', $header[$i]['align'], $fill);
				$i++;
			}
			$fill = !$fill;
			$pdf->Ln();
		}
		//download dengan nama laporan.pdf
		$pdf->Output('D','laporan.pdf'); 		
		
	}
	function laporanxls($idkat)
	{
		//cari nama kategori
		if($idkat=='') 
		{
			$nmkategori = "SEMUA KATEGORI";
		}else
		{
			$dtkat = $this->Lapbarangmodel->getKategori($idkat);
			$nmkategori = $dtkat[0]['namakat'];
		}
		//ambil data barang
		$dtbarang = $this->Lapbarangmodel->getBarang($idkat);
		
		$spreadsheet = new Spreadsheet();
		$spreadsheet->setActiveSheetIndex(0)
					->setCellValue('A1', 'LAPORAN DATA BARANG');
        $spreadsheet->setActiveSheetIndex(0)
					->setCellValue('A3', 'Kode Barang')
					->setCellValue('B3', 'Nama Barang')
					->setCellValue('C3', 'Harga')
					->setCellValue('D3', 'Stok');
        
		//looping data
		$i=4; 
		foreach ($dtbarang as $id=>$dt)
		{
			$spreadsheet->setActiveSheetIndex(0)
						->setCellValue('A'.$i, $dt['kdbarang'])	
						->setCellValue('B'.$i, $dt['nmbarang'])	
						->setCellValue('C'.$i, $dt['stok'])	
						->setCellValue('D'.$i, $dt['harga']);	
			$i++;
		}
		$spreadsheet->getActiveSheet()->setTitle('Laporan Barang '.date('d-m-Y'));

		$writer = new Xlsx($spreadsheet);
        $filename = 'laporan';
        header('Content-Type: application/vnd.ms-excel');
        header('Content-Disposition: attachment;filename="'. $filename .'.xlsx"'); 
        header('Cache-Control: max-age=0');
        $writer->save('php://output'); // download file 
	}
	
}

