<?php if ( ! defined('BASEPATH')) exit('No direct script access allowed');

class Gantipass extends CI_Controller {

	public function __construct()
	{
		parent::__construct();

		$this->load->library('grocery_CRUD');
		$this->data['judulhalaman'] = 'Management User';
		$this->mylib->cek_adm_login();
	}

	public function index()
	{
		$crud = new grocery_CRUD();

		$crud->set_table('login');
		$crud->where('username',$this->session->userdata('username'));
		$crud->set_subject('Login User');
		$crud->columns('username','nama','email','idlevel');
		$crud->required_fields('username','password','nama','email','idlevel');
		$crud->display_as('idlevel','Level');
		$crud->change_field_type('password','password');
		$crud->set_relation('idlevel','level','namalevel');
		$crud->unset_add();
		$crud->unset_delete();
		$crud->unset_print();
		$crud->unset_export();
		$crud->field_type('username', 'readonly');
		
		//cek dia gak boleh edit atau delete user lain
		$state = $crud->getState();
		$xuser = $this->uri->segment(5); //ambil username di segment 5 (adm/Gantipass/index/edit/away)
		

		if($state=='edit' || $state=='delete')
		{
			if($xuser!=$this->session->userdata('username'))
			{
				redirect('adm/Gantipass');
			}
		}
		
		//ganti password jadi md5
		$crud->callback_before_insert(array($this,'encrypt_password'));
		$crud->callback_before_update(array($this,'encrypt_password'));

		$crud->unset_clone();
		$output = $crud->render();
		
		
		$this->load->template_adm('Gantipass_view',(array)$output);
	}
	function encrypt_password($post_array)
	{
		//die(print_r($post_array));
		  $post_array['password'] = md5($post_array['password']);
		  return $post_array;

	}
	

}
