<?php if ( ! defined('BASEPATH')) exit('No direct script access allowed');

class Barang extends CI_Controller {

	public function __construct()
	{
		parent::__construct();

		$this->load->library('grocery_CRUD');
		$this->mylib->cek_adm_login();
		//ambil url controllernya untuk hak akses
		$this->load->Model('penjualan/Levelmenumodel');
		$this->data['urlcontroller'] = $this->uri->segment(2);
		$this->data['hakakses'] = $this->Levelmenumodel->getAkses($this->session->userdata('level'),$this->data['urlcontroller']);
	}

	public function index()
	{
		$crud = new grocery_CRUD();
	
		$crud->set_table('barang');			
		$crud->set_subject('Barang');
		if($this->data['hakakses']['cancreate']!='1') $crud->unset_add();
		if($this->data['hakakses']['candelete']!='1') $crud->unset_delete();
		if($this->data['hakakses']['canupdate']!='1') $crud->unset_edit();
		if($this->data['hakakses']['canread']!='1') {
			$crud->unset_read();
			$crud->unset_print();
			$crud->unset_export();
			//$crud->unset_list();
		}
		$crud->display_as('kdbarang','Kode Barang')
			 ->display_as('nmbarang','Nama Barang')
			 ->display_as('deskripsi','Deskripsi Barang')
			 ->display_as('idmerek','Merek')
			 ->display_as('idkat','Kategori');
		//ubah jadi textarea, default pake ckeditor
		 $crud->unset_texteditor('deskripsi','full_text');
		$state = $crud->getState();
		
		$crud->callback_column('deskripsi',array($this,'_callback_deskripsi'));

		  
		//kode barang tidak boleh sama saat insert
		if($state == 'add')
		{
			$crud->required_fields('kdbarang','nmbarang','deskripsi','stok','idkat');
			$crud->set_rules('kdbarang','Kode Barang','is_unique[barang.kdbarang]');
		}
		if($state == 'edit')
		{
			$crud->field_type('kdbarang','hidden');
		}
		

		$crud->set_relation('idkat','katbarang','namakat');
		$crud->set_relation('idmerek','merek','namamerek');
		//ubah jadi file field untuk upload
		$crud->set_field_upload('foto','assets/uploads/files');
		
		$output = $crud->render();
		
		
		$this->load->template_adm('Barang_view',(array)$output);
	}
	function _callback_deskripsi($value)
	{
		return wordwrap($value,30,"<br>\n");
	}
	
}

