<?php
defined('BASEPATH') OR exit('No direct script access allowed');

class Dosen extends CI_Controller{
	function __construct()
	{
		parent::__construct();
		//panggil library untuk validasi form
		$this->load->library('form_validation');
		//panggil model
		$this->load->model('Dosen_model');
		//untuk konversi jenis kelamin 
		$this->data['jenkel'] = array('L'=>'Laki-laki','P'=>'Perempuan');
	}
	public function index()
	{
		//ambil semua data
		$dosen  = $this->Dosen_model->alldata();
		//jika ada datanya
		if($dosen){
			//looping ambil semua data
			foreach($dosen as $index=>$value)
			{
				//ambil keterangan jenis kelamin 
				$value['ketjenkel'] = $this->data['jenkel'][$value['jenkel']];
				$data['dosen'][] = $value;
			}
		}else{
			//jika tidak ada, data kosong
			$data['dosen'] = array();
		}
		//panggil view
		$this->load->view('Dosen_view',$data);
	}
	public function tambah()
	{
		//siapkan data jenkel
		$data['jenkel'] = $this->data['jenkel'];
		//panggil view
		$this->load->view('Tambahdosen_view',$data); 
	}
	public function simpan(){
		$data['jenkel'] = $this->data['jenkel'];
		//pastikan tombol simpan diklik
		if($this->input->post('tblsimpan'))
		{
			//ambil data dan jadikan array
			$dt['nik'] = $this->input->post('nik');
			$dt['nama'] = $this->input->post('nama');
			$dt['alamat'] = $this->input->post('alamat');
			$dt['notelp'] = $this->input->post('notelp');
			$dt['jenkel'] = $this->input->post('jenkel');
			//validasi dulu, required = harus diisi, is_unique = tidak boleh sama dengan data lain
			$this->form_validation->set_rules('nik', 'NIK', 'required|is_unique[dosen.nik]');
			$this->form_validation->set_rules('nama', 'Nama', 'required');
			$this->form_validation->set_rules('alamat', 'Alamat', 'required');
			$this->form_validation->set_rules('jenkel', 'Jenis Kelamin', 'required');
			if ($this->form_validation->run() == TRUE){
				//jika validasi sukses, simpan data
				$simpan = $this->Dosen_model->simpan($dt);
				//kembali ke controller dosen
				redirect('Dosen');
			}else{
				//tampilkan view tambah dosen
				$this->load->view('Tambahdosen_view',$data); 
			}
		}else{
			redirect('Dosen');
		}
	}
	
	function hapus($nik)
	{
		//action hapus
		$this->Dosen_model->hapus($nik);
		redirect('Dosen');
	}
	function ubah($nik){
		//untuk form ubah
		$data['jenkel'] = $this->data['jenkel'];
		$data['dosen'] = $this->Dosen_model->getData($nik);
		$this->load->view('Ubahdosen_view',$data); 
	}
	function prosesubah(){
		//action ubah
		if($this->input->post('tblsimpan'))
		{
			$nik = $this->input->post('nik');
			$dt['nama'] = $this->input->post('nama');
			$dt['alamat'] = $this->input->post('alamat');
			$dt['notelp'] = $this->input->post('notelp');
			$dt['jenkel'] = $this->input->post('jenkel');
			//validasi dulu
			$this->form_validation->set_rules('nama', 'Nama', 'required');
			$this->form_validation->set_rules('alamat', 'Alamat', 'required');
			$this->form_validation->set_rules('jenkel', 'Jenis Kelamin', 'required');
			if ($this->form_validation->run() == TRUE){
				$simpan = $this->Dosen_model->ubah($dt,$nik);
				redirect('Dosen');
			}
		}else{
			redirect('Dosen');
		}
	}
}
